/*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Application
 *
 *  AUTHOR: Srivastav Janapalli
 *
 *  EMAIL: sjana086@uottawa.ca
 *
 *  DATE: 30/10/2016
 *
 *******************************************************************/

/** include files **/
#include "application.h"
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
 * Function Name: Application
 * Description:
 ********************************************************************/
Application::Application(const string &name) :
			Atomic(name),
			applicationIN(
					addInputPort("applicationIN")),
			applicationFillingComplete(
					addInputPort("applicationFillingComplete")),
			applicationOUT(
					addOutputPort("applicationOUT")),
			applicationTime(0, 0, 5, 0) {

}

/*******************************************************************
 * Function Name: initFunction
 * Description:
 * Precondition:
 ********************************************************************/
Model &Application::initFunction() {
	this-> passivate();
	return *this;
}

/*******************************************************************
 * Function Name: externalFunction
 * Description:
 ********************************************************************/
Model &Application::externalFunction(const ExternalMessage &msg) {
	if (msg.port() == applicationIN && this->state() == passive) {
		totalApplicationNum = static_cast<int> (msg.value());
		if (totalApplicationNum > 0) {
			applicationNum = 1;
			done = false;
			sendApplication = true;
			holdIn(active, applicationTime);
		}
	}
	if (msg.port() == applicationFillingComplete) {
		done = true;
		sendApplication = false;
		holdIn(active, Time::Zero);
	}
	return *this;
}

/*******************************************************************
 * Function Name: internalFunction
 * Description:
 ********************************************************************/
Model &Application::internalFunction(const InternalMessage &) {
	if (done) {
		if (applicationNum < totalApplicationNum) {
			applicationNum++;
			done = false;
			sendApplication = true;
			holdIn(active, applicationTime);
		} else
			passivate();
	} else
		passivate();
	return *this;
}

/*******************************************************************
 * Function Name: outputFunction
 * Description:
 ********************************************************************/
Model &Application::outputFunction(const InternalMessage &msg) {
	if (sendApplication) {
		sendOutput(msg.time(), applicationOUT, applicationNum);
	}
	return *this;
}
